library ieee;
use ieee.std_logic_1164.all;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity clock_generators is
	port (
		clk_125p_i : in std_logic;
		clk_125n_i : in std_logic;
		clk_125_o  : out std_logic;
		clk_100_o  : out std_logic;
		clk_200_o  : out std_logic;

		clk_25_i          : in  std_logic;
		clk_125_rata_o    : out std_logic;
		clk_125_90_rata_o : out std_logic;

		clk_200_i       : in std_logic;
		clk_200_butis_o : out std_logic;
		clk_125_butis_o : out std_logic;
		clk_10_butis_o  : out std_logic;

		clk_125_mux_i    : in std_logic;
		clk_125_mux_o    : out std_logic;
		clk_125_90_mux_o : out std_logic;

		locked_25_o         : out std_logic;
		locked_100_o        : out std_logic;
		locked_125_o        : out std_logic;
		locked_200_butis_o  : out std_logic;
		stopped_200_butis_o : out std_logic
	);
end;

architecture a of clock_generators is
	signal clk_100 : std_logic := '0';
	signal clk_125 : std_logic := '0';
	signal clk_125_mux: std_logic := '0';
	signal clk_125_rata : std_logic := '0';
	signal clk_125_90_rata : std_logic := '0';
	signal clk_200 : std_logic := '0';
	signal locked : std_logic := '0';
	signal locked4 : std_logic := '0';
	signal locked5 : std_logic := '0';
	signal locked6 : std_logic := '0';
	signal reset : std_logic := '0';
	signal stopped_200_butis : std_logic := '0';

begin

	stopped_200_butis_o <= stopped_200_butis;

	clocks : entity work.clocks1
	port map (
		clk_125_i_p => clk_125p_i,
		clk_125_i_n => clk_125n_i,
		clk_125_o   => clk_125,
		clk_100_o   => clk_100,
		clk_200_o   => clk_200,
		reset       => reset,
		locked      => locked
	);

	clocks_125 : entity work.clocks6
	port map (
		clk_125_in => clk_125_mux_i,
		clk_125    => clk_125_mux_o,
		clk_125_90 => clk_125_90_mux_o,
		reset      => reset,
		locked     => locked6
	);

	clocks_rataclock : entity work.clocks4
	port map (
		clk_25_i => clk_25_i,
		clk_125_o => clk_125_rata,
		clk_125_90_o => clk_125_90_rata,
		reset => reset,
		locked => locked4
	);

	clocks_butis : entity work.clocks5
	port map(
		clk_200_i => clk_200_i,
		clk_200_o => clk_200_butis_o,
		clk_125_o => clk_125_butis_o,
		clk_10_o  => clk_10_butis_o,
		reset => reset,
		locked => locked5
	);

	clk_125_o         <= clk_125;
	clk_125_rata_o    <= clk_125_rata;
	clk_125_90_rata_o <= clk_125_90_rata;
	clk_100_o         <= clk_100;
	clk_200_o         <= clk_200;

	locked_100_o       <= locked;
	locked_25_o        <= locked4;
	locked_200_butis_o <= locked5;
	locked_125_o       <= locked6;

end a;

-- vim: sw=4 ts=4
