library ieee;
use ieee.std_logic_1164.all;
library UNISIM;
use UNISIM.Vcomponents.ALL;

-- This is a clock multiplexer with 4 inputs
-- made up with cascaded BUFGMUX

entity clock_multiplexer4 is
	port (
		clk_select : in std_logic_vector(1 downto 0);
		clk_in0 : in std_logic;
		clk_in1 : in std_logic;
		clk_in2 : in std_logic;
		clk_in3 : in std_logic;
		clk_out : out std_logic
	);
end;

architecture a of clock_multiplexer4 is
	signal clk_01 : std_logic := '0';
	signal clk_23 : std_logic := '0';
	signal s_23 : std_logic := '0';
begin

	mux01 : BUFGMUX
	generic map (CLK_SEL_TYPE => "ASYNC")
	port map (
		S => clk_select(0),
		I0 => clk_in0,
		I1 => clk_in1,
		O => clk_01
	);
	
	mux23 : BUFGMUX
	generic map (CLK_SEL_TYPE => "ASYNC")
	port map (
		S => clk_select(0),
		I0 => clk_in2,
		I1 => clk_in0,
		O => clk_23
	);
	
	mux0123 : BUFGMUX
	generic map (CLK_SEL_TYPE => "ASYNC")
	port map (
		S => clk_select(1),
		I0 => clk_01,
		I1 => clk_23,
		O => clk_out
	);
	
end;
