library ieee;
use ieee.std_logic_1164.all;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity io_buffers is
	generic (
		any_in_width : integer;
		lemo_out_width : integer;
		lemo_in_width : integer;
		lvds_out_width : integer;
		ecl_out_width : integer
	);
	port (
		lemo_out_i : in std_logic_vector(lemo_out_width - 1 downto 0);
		lemo_out_o : out std_logic_vector(lemo_out_width - 1 downto 0);
		ecl_out_i : in std_logic_vector(ecl_out_width - 1 downto 0);
		ecl_out_o : out std_logic_vector(ecl_out_width - 1 downto 0);
		lemo_in_i : in std_logic_vector(lemo_in_width - 1 downto 0);
		lemo_in_o : out std_logic_vector(lemo_in_width - 1 downto 0);
		any_in_i : in std_logic_vector(any_in_width - 2 downto 1);
		any_in_o : out std_logic_vector(any_in_width - 2 downto 1);
		lvds_out_i : in std_logic_vector(lvds_out_width - 1 downto 0);
		lvds_out_o : out std_logic_vector(lvds_out_width - 1 downto 0);
	    -- res 7 is the UART tx
		res_i : in std_logic_vector(6 downto 0);
		res_o : out std_logic_vector(6 downto 0);
		led_i : in std_logic_vector(7 downto 0);
		display_led_i : in std_logic_vector(2 downto 0);
		display_led_o : out std_logic_vector(2 downto 0);
		hpv_o : out std_logic_vector(7 downto 0);
		select_out_o : out std_logic_vector(1 downto 0)
	);
end;

architecture a of io_buffers is

	signal led_inv : std_logic_vector(7 downto 0);
	signal display_led_inv : std_logic_vector(2 downto 0);

begin

	lemo_out : for i in 0 to lemo_out_width - 1 generate
		output_buffer : OBUF
		port map (
			o => lemo_out_o(i),
			i => lemo_out_i(i)
		);
	end generate;

	ecl_out : for i in 0 to ecl_out_width - 1 generate
		output_buffer : OBUF
		port map (
			o => ecl_out_o(i),
			i => ecl_out_i(i)
		);
	end generate;

	lvds_out : for i in 0 to lvds_out_width - 1 generate
		output_buffer : OBUF
		port map (
			o => lvds_out_o(i),
			i => lvds_out_i(i)
		);
	end generate;

	lemo_in : for i in 0 to lemo_in_width - 1 generate
		input_buffer : IBUF
		port map (
			o => lemo_in_o(i),
			i => lemo_in_i(i)
		);
	end generate;

	-- these are only 7 inputs (index 7 is an output for UART tx)
	res : for i in 0 to 6 generate
		input_buffer : IBUF
		port map (
			o => res_o(i),
			i => res_i(i)
		);
	end generate;

	-- these are only 6 inputs (0 and 7 are clock inputs and handled elsewhere)
	any_in : for i in 1 to any_in_width - 2 generate
		input_buffer : IBUF
		port map (
			o => any_in_o(i),
			i => any_in_i(i)
		);
	end generate;
	
	hpv_out : for i in 0 to 7 generate
		output_buffer : OBUF
		port map (
			o => hpv_o(i),
			i => led_inv(i)
		);
	end generate;

	display_light_out : for i in 0 to 2 generate
		output_buffer : OBUFT
		port map (
			o => display_led_o(i),
			i => '0',
			t => display_led_inv(i)
		);
	end generate;

	display_led_inv <= not display_led_i;
	led_inv <= not led_i;

	select_0 : OBUF port map (o => select_out_o(0), i => '0'); -- NIM out on
	select_1 : OBUF port map (o => select_out_o(1), i => '1'); -- TTL out off

end a;

-- vim: sw=4 ts=4
