library ieee;
use ieee.std_logic_1164.all;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity clock_generators is
	port (
		-- inputs before multiplexer
		clk_125p_i    : in std_logic;  -- from internal oscillator
		clk_125n_i    : in std_logic;  -- ^
		clk_25_i      : in  std_logic; -- from ratatime input
		clk_200_i     : in std_logic;  -- from butis input

		-- inputs after multiplexer
		clk_200_mux_i : in std_logic;

		-- outputs before multiplexer
		clk_200_internal_o : out std_logic;
		clk_200_rata_o     : out std_logic;
		clk_200_butis_o    : out std_logic;

		-- outputs after multiplexer
		clk_100_o    : out std_logic;
		clk_200_o    : out std_logic;
		clk_200_90_o : out std_logic;

		locked_internal_o  : out std_logic;
		locked_rataclock_o : out std_logic;
		locked_butis_o     : out std_logic;
		locked_200_o       : out std_logic
	);
end;

architecture a of clock_generators is
	signal clk_200_internal : std_logic := '0';
	signal clk_200_rata     : std_logic := '0';
	signal clk_200_butis    : std_logic := '0';
	signal clk_100          : std_logic := '0';
	signal clk_200          : std_logic := '0';
	signal clk_200_90       : std_logic := '0';
	signal locked : std_logic := '0';
	signal locked5 : std_logic := '0';
	signal locked7 : std_logic := '0';
	signal locked8 : std_logic := '0';
	signal reset : std_logic := '0';

begin

	-- Input clock PLLs
	clocks_internal : entity work.clocks1
	port map (
		clk_125_i_p => clk_125p_i,
		clk_125_i_n => clk_125n_i,
		clk_125_o   => open,
		clk_100_o   => open,
		clk_200_o   => clk_200_internal,
		reset       => reset,
		locked      => locked
	);

	clocks_rataclock_200 : entity work.clocks7
	port map (
		clk_25_i   => clk_25_i,
		clk_200_o  => clk_200_rata,
		reset      => reset,
		locked     => locked7
	);

	clocks_butis_200 : entity work.clocks5
	port map(
		clk_200_i => clk_200_i,
		clk_200_o => clk_200_butis,
		clk_125_o => open,
		clk_10_o  => open,
		reset     => reset,
		locked    => locked5
	);

	-- PLL after clock multiplexer
	clocks_after_mux_200 : entity work.clocks8
	port map (
		clk_200_i    => clk_200_mux_i,
		clk_200_o    => clk_200,
		clk_200_90_o => clk_200_90,
		clk_100_o    => clk_100,
		reset        => reset,
		locked       => locked8
	);

	clk_200_internal_o <= clk_200_internal;
	clk_200_rata_o     <= clk_200_rata;
	clk_200_butis_o    <= clk_200_butis;
	clk_100_o          <= clk_100;
	clk_200_o          <= clk_200;
	clk_200_90_o       <= clk_200_90;

	locked_internal_o  <= locked;
	locked_rataclock_o <= locked7;
	locked_butis_o     <= locked5;
	locked_200_o       <= locked8;

end a;

-- vim: sw=4 ts=4
