library ieee;
use ieee.std_logic_1164.all;
library UNISIM;
use UNISIM.Vcomponents.ALL;

-- This is a clock multiplexer with 2 inputs
-- made up with one BUFGMUX

entity clock_multiplexer2 is
	port (
		clk_select : in std_logic;
		clk_in0 : in std_logic;
		clk_in1 : in std_logic;
		clk_out : out std_logic
	);
end;

architecture a of clock_multiplexer2 is
begin

	mux01 : BUFGMUX
	generic map (CLK_SEL_TYPE => "ASYNC")
	port map (
		S => clk_select,
		I0 => clk_in0,
		I1 => clk_in1,
		O => clk_out
	);
end;
